﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Forms;
using System.IO;

namespace Notatnik.NET_2014
{
    class PlikiTekstowe
    {
        public static string[] CzytajPlikTekstowy(string ścieżkaPliku)
        {
            /*
            StreamReader sr = null;
            try
            {
                List<string> listaWierszy = new List<string>();
                sr = new StreamReader(ścieżkaPliku, Encoding.Default);
                string wiersz;
                while((wiersz = sr.ReadLine()) != null)
                {
                    listaWierszy.Add(wiersz);
                }
                return listaWierszy.ToArray();
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd odczytu pliku: " + exc.Message, "Błąd",
                    MessageBoxButtons.OK, MessageBoxIcon.Error);
                return null;
            }
            finally
            {
                if (sr != null) sr.Close();
            }
            */

            try
            {
                using (StreamReader sr = new StreamReader(ścieżkaPliku, Encoding.Default))
                {
                    List<string> listaWierszy = new List<string>();
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                    {
                        listaWierszy.Add(wiersz);
                    }
                    return listaWierszy.ToArray();
                }
            }
            catch (Exception exc)
            {
                //MessageBox.Show("Błąd odczytu pliku: " + exc.Message, "Błąd", MessageBoxButtons.OK, MessageBoxIcon.Error);
                //return null;
                throw new Exception("Błąd odczytu pliku: " + exc.Message);                
            }
        }

        public static void ZapiszDoPlikuTekstowego(string ścieżkaPliku, string[] wiersze)
        {
            try
            {
                using (StreamWriter sw = new StreamWriter(ścieżkaPliku))
                {
                    /*                    
                    for (int i = 0; i < wiersze.Length; ++i)
                    {
                        sw.WriteLine(wiersze[i]);
                    }
                    */
                    foreach(string wiersz in wiersze)
                    {
                        sw.WriteLine(wiersz);
                    }
                }
            }
            catch (Exception exc)
            {
                //MessageBox.Show("Błąd zapisu pliku: " + exc.Message, "Błąd",MessageBoxButtons.OK, MessageBoxIcon.Error);
                throw new Exception("Błąd zapisu pliku: " + exc.Message);
            }
        }
    }
}
